/* 
 * prids.c 
 *
 * Виводить власні ідентифікатори перед і після демонізації.
 * Ілюструє порядок застосування функцій getpid(), getppid(), getpgrp(),
 * getpgid(), getsid(), daemon().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* Для getsid(), getpgid() */
#define __USE_XOPEN_EXTENDED
#include <unistd.h>


void print_ids()
{
        printf("The process ID is %u\n", (unsigned int) getpid());
        printf("The parent process ID is %u\n", (unsigned int) getppid());
#if 0
        printf("The process group ID is %u\n", (unsigned int) getpgrp());
#endif
        printf("The process group ID is %u\n", (unsigned int) getpgid(0));
        printf("The process session ID is %u\n", (unsigned int) getsid(0));
}

int main()
{
        char outfile[] = "myout.txt";

        /* Виводить ідентифікатори. */
        print_ids();

        /* Перенаправляє стандартні потоки виведення. */
        if (freopen(outfile, "w", stdout) == NULL) {
                fprintf(stderr, "Can't associate stdout with file %s:"
                                        " %s\n", outfile, strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Встановлює для потоку stdout порядкову буферизацію.
           Еквівалент setvbuf(stdout, (char *)NULL, _IOLBF, 0); */
        setlinebuf(stdout);
        if (freopen(outfile, "w", stderr) == NULL) {
                fprintf(stderr, "Can't associate stderr with file %s:"
                                        " %s\n", outfile, strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Відключає для потоку stderr буферизацію.
           Еквівалент setvbuf(stderr, (char *)NULL, _IONBF, BUFSIZ); */
        setbuf(stderr, NULL);
        /* Закриває стандартний потік уведення. */
        if (fclose(stdin) == EOF)
                fprintf(stderr, "Error closing stdin: %s\n",
                                                strerror(errno));

        /* Демонізується. */
        if (daemon(1, 1) != 0) {
                fprintf(stderr, "Can't daemonize: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Чекає, доки завершиться батьківський процес. */
        sleep(1);
        /* Виводить ідентифікатори. */
        print_ids();
#if 0
        pause();
#endif
        exit(EXIT_SUCCESS);
} 
